package gov.va.med.mhv.sm.admin.web.clientfactory.deserializer;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;

public class JavaUtilDateDeserializer implements JsonDeserializer<Date> {

	public static String INCOMING_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
	public static String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";

	@Override
	public Date deserialize(JsonElement json, Type arg1,
			JsonDeserializationContext arg2) throws JsonParseException {

		String dateString = json.getAsJsonPrimitive().getAsString();

		// Instant instant =
		// Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong());
		// return Date.from(instant);
		// Date date=new Date(json.getAsJsonPrimitive().getAsLong()); //If Dates
		// comes as long
		Date date = null;
		Date formattedDate = null;
		try {
			System.out.println("INCOMING DATE STRING: " + dateString);
			// date = new
			// SimpleDateFormat(INCOMING_DATE_PATTERN).parse(dateString);

			DateTimeFormatter dtf = DateTimeFormat.forPattern(INCOMING_DATE_PATTERN);
			DateTime dateTime = dtf.parseDateTime(dateString);

			Date dateNew = dateTime.toDate();
			DateFormat df = new SimpleDateFormat(RFC1123_PATTERN);
			formattedDate = df.parse(df.format(dateNew));
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// return date;
		return formattedDate;

	}
}